/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.morefurniture.datagen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mrcrayfish.furniture.block.CoffeeTableBlock;
import com.mrcrayfish.morefurniture.Generator;
import com.mrcrayfish.morefurniture.init.ModBlocks;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.data.loot.ChestLootTables;
import net.minecraft.data.loot.EntityLootTables;
import net.minecraft.data.loot.FishingLootTables;
import net.minecraft.data.loot.GiftLootTables;
import net.minecraft.entity.EntityType;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.ILootConditionConsumer;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.PiglinBarteringAddition;
import net.minecraft.loot.conditions.BlockStateProperty;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.state.Property;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.data.ForgeLootTableProvider;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;

public class LootTableGen
extends ForgeLootTableProvider {
    private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> tables = ImmutableList.of((Object)Pair.of(() -> new FishingProvider(), (Object)LootParameterSets.field_216262_c), (Object)Pair.of(() -> new ChestProvider(), (Object)LootParameterSets.field_216261_b), (Object)Pair.of(() -> new EntityProvider(), (Object)LootParameterSets.field_216263_d), (Object)Pair.of(() -> new BlockProvider(), (Object)LootParameterSets.field_216267_h), (Object)Pair.of(() -> new PiglinBarteringProvider(), (Object)LootParameterSets.field_237453_h_), (Object)Pair.of(() -> new GiftProvider(), (Object)LootParameterSets.field_216264_e));

    public LootTableGen(DataGenerator generator) {
        super(generator);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        return this.tables;
    }

    private static Block getResultBlock(Generator.Variant variant, Generator.FurnitureType type, boolean stripped) {
        try {
            String fieldFormat = stripped ? "%s_%s_STRIPPED_%s" : "%s_%s_%s";
            String fieldName = String.format(fieldFormat, variant.getLog().getRegistryName().func_110624_b().toUpperCase(), type.getId().toUpperCase(), variant.getId().toUpperCase());
            RegistryObject block = (RegistryObject)ModBlocks.class.getField(fieldName).get(null);
            return (Block)block.get();
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static class GiftProvider
    extends GiftLootTables {
        private GiftProvider() {
        }

        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> registry) {
        }
    }

    private static class PiglinBarteringProvider
    extends PiglinBarteringAddition {
        private PiglinBarteringProvider() {
        }

        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> registry) {
        }
    }

    private static class BlockProvider
    extends BlockLootTables {
        private BlockProvider() {
        }

        protected void addTables() {
            Generator generator = new Generator();
            for (Generator.FurnitureType type : Generator.FURNITURE_TYPES) {
                for (Generator.Variant variant : generator.getRegisteredVariants()) {
                    Consumer<Block> register = type == Generator.COFFEE_TABLE ? this::registerCoffeeTable : arg_0 -> ((BlockProvider)this).func_218492_c(arg_0);
                    register.accept(LootTableGen.getResultBlock(variant, type, false));
                    if (variant.getStrippedLog() == null) continue;
                    register.accept(LootTableGen.getResultBlock(variant, type, true));
                }
            }
        }

        public void registerCoffeeTable(Block block) {
            this.func_218522_a(block, coffeeTable -> LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)BlockProvider.func_218560_a((IItemProvider)block, (ILootConditionConsumer)ItemLootEntry.func_216168_a((IItemProvider)coffeeTable).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)2)).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)coffeeTable).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227195_a_((Property)CoffeeTableBlock.TALL, true))))))));
        }

        protected Iterable<Block> getKnownBlocks() {
            return ForgeRegistries.BLOCKS.getValues().stream().filter(entityType -> entityType.getRegistryName() != null && "morecfm".equals(entityType.getRegistryName().func_110624_b())).collect(Collectors.toSet());
        }
    }

    private static class EntityProvider
    extends EntityLootTables {
        private EntityProvider() {
        }

        protected void addTables() {
        }

        protected Iterable<EntityType<?>> getKnownEntities() {
            return ForgeRegistries.ENTITIES.getValues().stream().filter(entityType -> entityType.getRegistryName() != null && "morecfm".equals(entityType.getRegistryName().func_110624_b())).collect(Collectors.toSet());
        }
    }

    private static class ChestProvider
    extends ChestLootTables {
        private ChestProvider() {
        }

        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> registry) {
        }
    }

    private static class FishingProvider
    extends FishingLootTables {
        private FishingProvider() {
        }

        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> registry) {
        }
    }
}

